@extends('layouts.layoutapp')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <!-- Card Header -->
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Invoices</h5>
                        </div>
                        @if(Auth::user()->user_flg !== 'C')
                            <a href="{{ route('invoice-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                Invoice</a>
                        @endif
                    </div>
                </div>
                <div class="card-body px-0 pt-0 pb-2">

                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0 table-hover" id="myTable2">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Action</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        ID</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Client</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Invoice Date</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Due Date</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Amount</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Payment Status</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Delivery Status</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Created by</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($invoices as $invoice)
                                    <tr>
                                        <td>
                                            @if(Auth::user()->user_flg !== 'C')
                                                <a href="{{ route('invoice-edit', $invoice->id) }}">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <form action="{{ route('invoice-delete', $invoice->id) }}" method="POST"
                                                    class="d-inline" id="delete-form-{{$invoice->id}}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <i class="cursor-pointer fas fa-trash text-secondary ms-2"
                                                        onclick="confirmDelete({{$invoice->id}})"></i>
                                                </form>
                                            @endif
                                            @if(Auth::user()->user_flg == 'C')
                                                <a href="javascript:void(0)" data-bs-toggle="modal"
                                                    data-bs-target="#updateStatusModal" data-id="{{ $invoice->id }}"
                                                    data-status="{{ $invoice->delivery_status }}"> <i
                                                        class="fa-solid fa-pen-to-square text-secondary"></i></a>
                                            @endif

                                            <a href="{{ route('pdf', $invoice->id) }}">
                                                <i class="fa-solid fa-download text-secondary ms-2"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">{{ $invoice->invoice_id }}</p>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">
                                                {{ Str::limit($invoice->client->user->name . ' ' . $invoice->client->user->last_name, 150) }}
                                            </p>
                                        </td>

                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">
                                                {{ $invoice->invoice_date ? \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') : '' }}
                                            </p>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">
                                                {{ $invoice->due_date ? \Carbon\Carbon::parse($invoice->due_date)->format('d-m-Y') : ''}}
                                            </p>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">
                                                {{ $invoice->final_amount }}
                                            </p>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">
                                                @php
                                                    $status = optional($payment_status->firstWhere('id', $invoice->status))->name;
                                                    $badgeClass = match ($status) {
                                                        'Paid' => 'bg-success',
                                                        'Partially Paid' => 'bg-warning text-dark',
                                                        'Unpaid' => 'bg-danger',
                                                    };
                                                @endphp

                                                <span class="badge {{ $badgeClass }}">
                                                    {{ $status ?? 'Unknown' }}
                                                </span>
                                            </p>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0">
                                                @if ($invoice->delivery_status == 1)
                                                    <span class="badge bg-info">
                                                        In Progress
                                                    </span>
                                                @elseif($invoice->delivery_status == 2)
                                                    <span class="badge bg-success">
                                                        Delivered
                                                    </span>
                                                @else
                                                    <span class="badge bg-secondary">
                                                        Unknown
                                                    </span>
                                                @endif
                                            </p>
                                        </td>
                                        <td>{{$invoice->createdBy->name ?? '' . ' ' . $invoice->createdBy->last_name ?? ''}}</td>

                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="updateStatusModal" tabindex="-1" aria-labelledby="updateStatusModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <form method="POST" action="{{ route('invoice-updateDeliveryStatus') }}">
                @csrf
                <input type="hidden" name="invoice_id" id="modal-invoice-id">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="updateStatusModalLabel">Update Delivery Status</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="delivery_status" class="form-label">Select Status</label>
                            <select class="form-select" name="delivery_status" id="modal-delivery-status" required>
                                <option value="">-- Select Status --</option>
                                <option value="1">In Progress</option>
                                <option value="2">Delivered</option>
                            </select>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
        const updateStatusModal = document.getElementById('updateStatusModal');
        updateStatusModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const invoiceId = button.getAttribute('data-id');
            const currentStatus = button.getAttribute('data-status');

            document.getElementById('modal-invoice-id').value = invoiceId;
            document.getElementById('modal-delivery-status').value = currentStatus;
        });

        $(document).ready(function () {
            $('#myTable2').DataTable({
                "order": [],
                layout: {
                    topStart: {
                        buttons: ['excel', 'pdf', 'print', 'colvis', 'pageLength']
                    },
                },
                lengthMenu: [[10, 250, 500, 750, 1000, -1], [10, 250, 500, 750, 1000, "All"]]
            });
        });
    </script>
@endpush